/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FilesSystem {
    private FileConnection cConnection;
    private String sPath;

    public FilesSystem(String string) {
        this.sPath = string;
    }

    private void close() {
        try {
            this.cConnection.close();
            this.cConnection = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private boolean open(int n) {
        try {
            this.cConnection = (FileConnection)Connector.open((String)("file://" + this.sPath), (int)n);
            return true;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            this.cConnection = null;
            return false;
        }
    }

    public boolean create() {
        boolean bl = false;
        this.open(3);
        try {
            if (this.cConnection != null) {
                if (this.cConnection.exists()) {
                    this.cConnection.delete();
                }
                this.cConnection.create();
                this.close();
            }
            bl = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return bl;
    }

    public String[] list() {
        this.open(1);
        String[] stringArray = null;
        if (this.cConnection != null) {
            Vector vector = new Vector();
            try {
                Enumeration enumeration = this.cConnection.list("*", true);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            this.close();
            stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = this.sPath + vector.elementAt(i);
            }
            vector = null;
        }
        return stringArray;
    }

    public static String[] listRoots() {
        String[] stringArray = null;
        Vector vector = new Vector();
        Enumeration enumeration = FileSystemRegistry.listRoots();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = "/" + vector.elementAt(i);
        }
        vector = null;
        return stringArray;
    }

    public boolean exists() {
        if (!this.open(1)) {
            return false;
        }
        boolean bl = false;
        if (this.cConnection != null) {
            bl = this.cConnection.exists();
            this.close();
        }
        return bl;
    }

    public byte[] read() {
        if (!this.open(1)) {
            return null;
        }
        byte[] byArray = null;
        try {
            long l = this.cConnection.fileSize();
            byArray = new byte[(int)l];
            DataInputStream dataInputStream = this.cConnection.openDataInputStream();
            if (l != (long)dataInputStream.read(byArray)) {
                byArray = null;
            }
            dataInputStream.close();
            dataInputStream = null;
            this.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            byArray = null;
        }
        return byArray;
    }

    public boolean write(byte[] byArray) {
        boolean bl = false;
        try {
            this.open(3);
            if (this.cConnection.exists()) {
                this.cConnection.delete();
            }
            this.cConnection.create();
            DataOutputStream dataOutputStream = this.cConnection.openDataOutputStream();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.close();
            bl = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return bl;
    }

    public boolean delete() {
        this.open(3);
        if (this.cConnection != null) {
            try {
                if (this.cConnection.exists()) {
                    this.cConnection.delete();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            this.close();
        }
        return true;
    }

    public boolean rename(String string) {
        this.open(3);
        if (this.cConnection != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            try {
                this.cConnection.rename(string);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            this.close();
        }
        return true;
    }

    public boolean mkdir() {
        this.open(3);
        if (this.cConnection != null) {
            try {
                if (!this.cConnection.exists()) {
                    this.cConnection.mkdir();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            this.close();
        }
        return true;
    }

    public long fileSize() {
        long l = -1L;
        this.open(1);
        if (this.cConnection != null) {
            try {
                l = this.cConnection.fileSize();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            this.close();
        }
        return l;
    }

    public boolean isDirectory() {
        boolean bl = false;
        this.open(1);
        if (this.cConnection != null) {
            bl = this.cConnection.isDirectory();
            this.close();
        }
        return bl;
    }

    public boolean canRead() {
        boolean bl = false;
        this.open(1);
        if (this.cConnection != null) {
            bl = this.cConnection.canRead();
            this.close();
        }
        return bl;
    }

    public boolean canWrite() {
        boolean bl = false;
        this.open(1);
        if (this.cConnection != null) {
            bl = this.cConnection.canWrite();
            this.close();
        }
        return bl;
    }

    public byte[] readFromJAR() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.sPath);
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            inputStream.close();
            inputStream = null;
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DataInputStream openDataInputStream() {
        DataInputStream dataInputStream;
        try {
            this.open(1);
            dataInputStream = this.cConnection.openDataInputStream();
        }
        catch (IOException iOException) {
            dataInputStream = null;
        }
        return dataInputStream;
    }

    public void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    public DataOutputStream openDataOutputStream() {
        DataOutputStream dataOutputStream;
        try {
            this.open(3);
            if (this.cConnection.exists()) {
                this.cConnection.delete();
            }
            this.cConnection.create();
            dataOutputStream = this.cConnection.openDataOutputStream();
        }
        catch (IOException iOException) {
            dataOutputStream = null;
        }
        return dataOutputStream;
    }

    public void closeOutputStream(OutputStream outputStream) {
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }
}

