#include "..\\include\Lib_Clara.h"
#include "..\\include\Dir.h"
#include "..\\include\var_arg.h"

#pragma swi_number=0x1B5
__swi __arm void REQUEST_PROFILE_SETACTIVEPROFILE(const int *__zero , int NUMprof);
#pragma swi_number=0x1BB
__swi __arm void Vibra(int t1, int t2, int t3);
#pragma swi_number=0x248
__swi __arm void Vibra_Off (int t1);


#define ELFNAME "MiniGPS 1.19"
#define ABOUT L"MiniGPS 1.19\n(c)copini\ntweaks by\nzoyd,Ploik,mousex\nJoker XT,Stonos\nBigHercules"

static char myappname[]=ELFNAME;

typedef struct
{
  BOOK * book;
} MSG;

unsigned char *cellData = 0;

BOOK * MiniGPSBook;
u16 * logFolder = 0;
u16 timer;
u16 timerNewAction;
u16 currentCell[16];
u16 lastCell[16];
u16 cellName[194]={0,};
u16 cellNameAction[194]={0,};
u16 lastCellName[194];
u16 lastCellNameAction[194];
u16 winUCodeFile[50];
u16 * SIwstr;
u16 * SIwstr2;
u16 SIlen;
char logCellName[194];
int wnd = 6;
int show = 0;
int keyMode = 0;
int logExt = 0;
int dateFormat = 0;
u16 timerVibra;
int vibrateMode = 0;
int vibrateTime = 70;
int vibrateLeft = 0;
int logMode = 0;
int updateInterval = 2000;
int alwaysUpdate = 0;
int ignoreKeyLock = 0;
int minNewAction = 600000;
u16 * soundFolder = 0;
bool visible = true;
int keyShowCellID = 0;
int keyAutoLoc = 0;
bool showCellID = false;
bool timerNewActionInitDone = false;
bool timerVibraInitDone = false;
bool AutoLocation=false;
bool LocFound=false;
int CellIdMode = 0;

int isMiniGPSBook(BOOK * book)
{
   if(!strcmp(book->xbook->name,myappname)) return true;
   return false;
}

void elf_exit(void) {
  kill_data(&ELF_BEGIN, (void(*)(void*))mfree_adr());
}

int TerminateElf(void *, BOOK* book) {
  FreeBook(book);
  return(1);
}

int ShowAuthorInfo(void *mess ,BOOK* book) {
  MSG * msg = (MSG*)mess;
  MessageBox(0x6FFFFFFF, Str2ID(ABOUT, 0, SID_ANY_LEN), 0, 1, 5000, msg->book);
  return(1);
}

const PAGE_MSG HW_PageEvents[]@ "DYN_PAGE" = {
  ELF_TERMINATE_EVENT, TerminateElf,
  ELF_SHOW_INFO_EVENT, ShowAuthorInfo,
  NIL_EVENT_TAG, NULL
};

PAGE_DESC base_page = {"HW_BasePage", 0, HW_PageEvents};

int h2i(char * h) {
  char c;
  int res=0;
  while((*h++) != 'x');
  do {
    c = *h++;
    if (c > 0x60) c -= 0x20; else c -= 0x30;
    if (c > 9) c -= 7;
    res <<= 4;
    res |= c;
  }
  while(*h != ';');
  return(res);
}

void location2unicode(u16 *ws, char *s, int len) 
{
  int c;
  int file;
  FSTAT fstat;
  bool isUCodeFile=false;
  char*buf=(char*)malloc(512);
  if(isFileExist(GetDir(DIR_INI), (u16*)winUCodeFile, &fstat) == 0)
  {
    if( ((file = _fopen(GetDir(DIR_INI), (u16*)winUCodeFile, 0x001, 0x180, 0)) >= 0) && fstat.fsize == 512 )
    {
      fread(file, buf, 512);
      isUCodeFile=true;
    }
    fclose(file);
  }
  while((c = *s++) && ((len--) > 0))   
  {
    if (c == 0x7E) c = 0x0A;
    if (isUCodeFile) c = (buf[2 * c] << 8)  | buf[2 * c + 1];
    *ws++ = c;

  }
  mfree(buf);
  *ws=0;
}

void onTimerVibra(u16 * unk, void * data) {
  if (vibrateLeft == 0) {
    Vibra_Off(100);
    return;
  }
  if (vibrateLeft == 4 || vibrateLeft == 2)
	Vibra_Off(100);
  else
    Vibra(100,100,0);
  vibrateLeft--;
  Timer_ReSet(&timerVibra, 70, onTimerVibra, 0);
}

void onTimerNewAction(u16 * unk, void * data) {
  wstrcpy(lastCellNameAction, cellNameAction);
  wstrcpy(cellNameAction, currentCell);
  wstr2strn(logCellName, cellNameAction, 193);

  int file;
  FSTAT fstat;

  if (isFileExist(GetDir(DIR_INI), _T("MiniGPS.ini"), &fstat) == 0) {
    if ((file = _fopen(GetDir(DIR_INI), _T("MiniGPS.ini"), 0x1, 0x180, 0)) >= 0) {
      char * buffer = new char[fstat.fsize + 1];
      buffer[fread(file, buffer, fstat.fsize)] = 0;

      char tempCell[16];
      char lacCidKey[20];
      if(CellIdMode == 0) {
        wstr2strn(tempCell, currentCell, 9);
      }
      else {
        wstr2strn(tempCell, currentCell, 11);
      }
      sprintf(lacCidKey, "[%s]", tempCell);

      if (char * param = manifest_GetParam(buffer, lacCidKey, 0)) {
        strcpy(logCellName, param);
        if (!showCellID) location2unicode(cellNameAction, param, SID_ANY_LEN);
        mfree(param);
      }

      if ( wstrcmp(cellNameAction, lastCellNameAction) != 0) {
        char *cellNameKey = new char[198];
         
        sprintf(cellNameKey, "[V_%s]", logCellName);
        if (vibrateLeft == 0) {
          if (char * param = manifest_GetParam(buffer, cellNameKey, 0)) {
            int tempVibrateMode = h2i(param);
            int tempVibrateTime = 70;
            if (tempVibrateMode == 1) vibrateLeft = 4;
            if (tempVibrateMode == 2) tempVibrateTime = 250;
            if (tempVibrateMode == 3) tempVibrateTime = 500;
            Vibra(100,100,0);
            if(!timerVibraInitDone){
              timerVibra = Timer_Set(tempVibrateTime, onTimerVibra, 0);
              timerVibraInitDone = true;
            }
            else
              Timer_ReSet(&timerVibra, tempVibrateTime, onTimerVibra, 0);
          }
        }

        if(soundFolder) {
          sprintf(cellNameKey, "[S_%s]", logCellName);
          if (char * param = manifest_GetParam(buffer, cellNameKey, 0)) {
            u16 *tempFileName = new u16[198];
            str2wstr(tempFileName, param);
            PlayFile(soundFolder, tempFileName);
            mfree(param);
            delete(tempFileName);
          }
        }

        sprintf(cellNameKey, "[P_%s]", logCellName);
        if (char * param = manifest_GetParam(buffer, cellNameKey, 0)) {
          REQUEST_PROFILE_SETACTIVEPROFILE(SYNC, h2i(param));
          mfree(param);
        }
        else if (char * param = manifest_GetParam(buffer, "[P_DEFAULT]", 0)) {
          REQUEST_PROFILE_SETACTIVEPROFILE(SYNC, h2i(param));
          mfree(param);
        }
        delete(cellNameKey);
      }

      fclose(file);
      delete(buffer);
    }
  }

  if (visible && !alwaysUpdate) {
    if (logCellName[0] == '*') {
      StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, 0x6FFFFFFF);
    } else {
      StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, Str2ID((u16*)cellName, 0, SID_ANY_LEN ));
    }
  }
}

void OKPressed()
{
  //Special thanks to Hussein for some of the following code ( http://mobilefree.ru/newbb_plus/viewtopic.php?topic_id=2479&post_id=77049#77049 )
  StringInput_GetStringAndLen((GUI*)MiniGPSBook->gui,&SIwstr,&SIlen);
  AutoLocation=true;
  MessageBox(0x6FFFFFFF, STR("TODO: Fix next bug (how?)"), 0, 1 ,5000, 0); //Inform the user that a bug exists.
  SIwstr2 = new u16[wstrlen(SIwstr)];
  wstrcpy(SIwstr2, SIwstr); //We must do that because trying to access SIwstr after using GUI_Free does not work for some reason.
  GUI_Free(MiniGPSBook->gui); //FIXME: Softkey text disappears after using this until user presses any key for 4 times!
                              //Workaround: Set focus to StandBy_Book, but user will still be able to use BookManager to access the SI dialog again.
  return;
}

void BackPressed()
{
  MessageBox(0x6FFFFFFF, STR("TODO: Fix next bug (how?)"), 0, 1 ,5000, 0); //Inform the user that a bug exists.
  GUI_Free(MiniGPSBook->gui); //FIXME: Softkey text disappears after using this until user presses any key for 4 times!
                              //Workaround: Set focus to StandBy_Book, but user will still be able to use BookManager to access the SI dialog again.

  return;
}

void AddToIni() 
{
  
  int file;
  FSTAT fstat;
  char * inibuffer = NULL;

  if (isFileExist(GetDir(DIR_INI), (u16*)L"MiniGPS.ini", &fstat) == 0) {
    if ((file = _fopen(GetDir(DIR_INI), (u16*)L"MiniGPS.ini", 0x1, 0x180, 0)) >= 0) {
      inibuffer = new char[fstat.fsize + 1];
      inibuffer[fread(file, inibuffer, fstat.fsize)] = 0;
      fclose(file);
    }
  }
  if ((file = _fopen(GetDir(DIR_INI), (u16*)L"MiniGPS.ini", 0x204, 0x180, 0)) >= 0) {
    if (strlen(inibuffer) > 0) {
      fwrite(file, inibuffer, strlen(inibuffer));
      delete(inibuffer);
    }
    
    u16 * wsnewini = new u16[40];
    char * snewini = new char[40];
    snwprintf(wsnewini,40, (u16*)L"[%02X%02X:%02X%02X]: %ls\r\n", cellData[7], cellData[8], cellData[1], cellData[0], SIwstr2);
    wstr2strn(snewini, wsnewini,35); //You may be able to do this using only sprintf to save power. I haven't tried that.
    fwrite(file, snewini, strlen(snewini)); //FIXME: Unicode characters might not work (haven't tested)
    fclose(file);
    delete(wsnewini);
    delete(snewini);
  }
  
  //TODO: Force redraw after this function is executed to show new location name.
  
  return;
}

void CheckCellName() {
  wstrcpy(lastCell, currentCell);
  wstrcpy(lastCellName, cellName);
  wstrcpy(cellName, currentCell);
  wstr2strn(logCellName, cellName, 193);

  int file;
  FSTAT fstat;

  if (vibrateMode > 0) {
    if (vibrateMode == 1) vibrateLeft = 4;
    Vibra(100,100,0);
    if(!timerVibraInitDone){
      timerVibra = Timer_Set(vibrateTime, onTimerVibra, 0);
      timerVibraInitDone = true;
    }
    else
      Timer_ReSet(&timerVibra, vibrateTime, onTimerVibra, 0);
  }

  if (isFileExist(GetDir(DIR_INI), _T("MiniGPS.ini"), &fstat) == 0) {
    if ((file = _fopen(GetDir(DIR_INI), _T("MiniGPS.ini"), 0x1, 0x180, 0)) >= 0) {
      char * buffer = new char[fstat.fsize + 1];
      buffer[fread(file, buffer, fstat.fsize)] = 0;

      char tempCell[16];
      char lacCidKey[20];
      if(CellIdMode == 0) {
        wstr2strn(tempCell, currentCell, 9);
      }
      else {
        wstr2strn(tempCell, currentCell, 11);
      }
      sprintf(lacCidKey, "[%s]", tempCell);

	  LocFound=false;
      
      if (char * param = manifest_GetParam(buffer, lacCidKey, 0)) {
        strcpy(logCellName, param);
        if (!showCellID) location2unicode(cellName, param, SID_ANY_LEN);
        LocFound=true;
        mfree(param);
      }

      if ( wstrcmp(cellName, lastCellName) != 0) {
        if(!timerNewActionInitDone){
          timerNewAction=Timer_Set(minNewAction, onTimerNewAction,0);
          timerNewActionInitDone = true;
        }
        else
          Timer_ReSet(&timerNewAction, minNewAction, onTimerNewAction,0);
      }

      fclose(file);
      delete(buffer);
	  if (LocFound==false && AutoLocation==true) {
        AddToIni();
      }
    }
  }

  if (visible && !alwaysUpdate) {
    if (logCellName[0] == '*') {
      StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, 0x6FFFFFFF);
    } else {
      StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, Str2ID((u16*)cellName, 0, SID_ANY_LEN ));
    }
  }

  if (logFolder == 0) return;

  if (logMode == 0x01 && wstrcmp(cellName, lastCellName) == 0) return;
  if (logMode == 0x02 && wstrcmp(cellName, currentCell) == 0) return;
  if (logMode == 0x03 && wstrcmp(cellName, currentCell) != 0) return;

  DATETIME dt;
  REQUEST_DATEANDTIME_GET(SYNC, &dt);

  u16 * logFile = new u16[15];
  if (dateFormat)
    snwprintf(logFile, 11, _T("%02d-%02d-%04d."), dt.date.day, dt.date.mon, dt.date.year);
  else
    snwprintf(logFile, 11, _T("%04d-%02d-%02d."), dt.date.year, dt.date.mon, dt.date.day);
  wstrcat(logFile, (logExt?_T("ini"):_T("txt")));

  char * logbuffer = NULL;

  if (isFileExist(logFolder, logFile, &fstat) == 0) {
    if ((file = _fopen(logFolder, logFile, 0x1, 0x180, 0)) >= 0) {
      logbuffer = new char[fstat.fsize + 1];
      logbuffer[fread(file, logbuffer, fstat.fsize)] = 0;
      fclose(file);
    }
  }
  if ((file = _fopen(logFolder, logFile, 0x204, 0x180, 0)) >= 0) {
    if(logbuffer) {
      if (strlen(logbuffer) > 0) {
        fwrite(file, logbuffer, strlen(logbuffer));
      }
    }

    char * newlog = new char[strlen(logCellName) + 32];
    if(CellIdMode == 0){
      sprintf(newlog, "%02d:%02d:%02d - [%02X%02X:%02X%02X] %s\n", dt.time.hour, dt.time.min, dt.time.sec, cellData[7], cellData[8], cellData[1], cellData[0], logCellName);
    }
    else {
      u16 cellLAC = cellData[8] | (cellData[7] << 8);
      u16 cellID  = cellData[0] | (cellData[1] << 8);
      sprintf(newlog, "%02d:%02d:%02d - [%05d:%05d] %s\n", dt.time.hour, dt.time.min, dt.time.sec, cellLAC, cellID, logCellName);
    }

    fwrite(file, newlog, strlen(newlog));
    fclose(file);
    delete(newlog);
  }

  if(logbuffer) delete(logbuffer);
  delete(logFile);
  return;
}

void onTimer(u16 * unk, void * data) {
  if(CellIdMode == 0) {
    snwprintf(currentCell, 9, (u16*)L"%02X%02X:%02X%02X", cellData[7], cellData[8], cellData[1], cellData[0]);
  }
  else {
    u16 cellLAC = cellData[8] | (cellData[7] << 8);
    u16 cellID  = cellData[0] | (cellData[1] << 8);
    snwprintf(currentCell, 11, (u16*)L"%05d:%05d", cellLAC, cellID);
  }
  if (wstrcmp(currentCell, lastCell) != 0) CheckCellName();
  if (visible && alwaysUpdate) {
    if (logCellName[0] == '*') {
      StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, 0x6FFFFFFF);
    } else {
      StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, Str2ID((u16*)cellName, 0, SID_ANY_LEN ));
    }
  }
  Timer_ReSet(&timer, updateInterval, onTimer, 0);
}

int NewKey(int key, int r1, int mode) {
  if (mode == keyMode && key == show && SESSION_GetTopBook(root_list_get_session(root_list_get_session_count() - 1)) == Find_StandbyBook()) {
   if (!isKeylocked() || ignoreKeyLock) {
     if (visible) {
       StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, 0x6FFFFFFF);
     } else if (logCellName[0] != '*') {
       StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, Str2ID((u16*)cellName, 0, SID_ANY_LEN ));
     }
     visible = !visible;
   }
  } else if (mode == 1 && key == keyShowCellID && SESSION_GetTopBook(root_list_get_session(root_list_get_session_count() - 1)) == Find_StandbyBook()) {
    showCellID = !showCellID;
    lastCell[0] = 0;
    onTimer((u16 *)0,(void *)0);
  } else if (mode == 1 && key == keyAutoLoc && SESSION_GetTopBook(root_list_get_session(root_list_get_session_count() - 1)) == Find_StandbyBook()) {
      //Special thanks to Hussein for the following code ( http://mobilefree.ru/newbb_plus/viewtopic.php?topic_id=2479&post_id=76940#76940 )
    if (AutoLocation==false) {
      GUI * si=(GUI *)CreateStringInput(0,
                                        VAR_BOOK(MiniGPSBook),
                                        VAR_STRINP_FIXED_TEXT(STR("Current location:")),
                                        VAR_STRINP_NEW_LINE(0),
                                        VAR_STRINP_ENABLE_EMPTY_STR(0),
                                        VAR_STRINP_MAX_LEN(20),
                                        VAR_OK_PROC(OKPressed),
                                        VAR_LONG_BACK_PROC(BackPressed),
                                        0);
      MiniGPSBook->gui=si; //FIXME: This does not work the second time. GUI will be created and will be selectable using BookManager, however will not automatically show up. I believe this has to do something with the way I use GUI_Free.
                           //Possible workaround 1: Set focus to our GUI after executing the above line.
                           //Possible workaround 2: Destroy MiniGPSBook and recreate it before executing the above 2 lines.
    } else {
      AutoLocation=false;
      MessageBox(0x6FFFFFFF, STR("Auto location disabled."), 0, 1 ,5000, 0);
    }
  }
  return(0);
}

void onCloseMiniGPSBook(BOOK * book) {
  if (book) {
    Timer_Kill(&timer);
    if(timerNewActionInitDone) Timer_Kill(&timerNewAction);
    if(timerVibraInitDone) Timer_Kill(&timerVibra);
    if(logFolder) delete(logFolder);
    if(soundFolder) delete(soundFolder);
    ModifyKeyHook(NewKey, 0);
    StatusIndication_SetItemText(SBY_GetStatusIndication(Find_StandbyBook()), wnd, 0x6FFFFFFF);
    SUBPROC(elf_exit);
  }
}

int GetSettings() {
  int file;
  FSTAT fstat;

  if (isFileExist(GetDir(DIR_INI), (u16*)L"MiniGPS.ini", &fstat) == 0) {
    if ((file = _fopen(GetDir(DIR_INI), (u16*)L"MiniGPS.ini", 0x1, 0x180, 0)) >= 0) {
      char * buffer = new char[fstat.fsize + 1];
      buffer[fread(file, buffer, fstat.fsize)] = 0;
      char * param;

      if (param = manifest_GetParam(buffer, "[PHONE]", 0)) {
        switch (h2i(param)) {
          case(0x00) : //W810_R4EA031
            cellData=(unsigned char *) (0x4C025610);
            break;
          case(0x01) : //K790_R8BF003
            cellData=(unsigned char *) (0x2018FEE0);
            break;
          case(0x02) : //W700_R1CA021
            cellData=(unsigned char *) (0x4C041978 );
            break;
          case(0x03) : //K750_R1CA021
            cellData=(unsigned char *) (0x4C0419C4);
            break;
          case(0x04) : //W800_R1BD001
            cellData=(unsigned char *) (0x4C041E10);
            break;
          case(0x05) : //W610_R6BC002
            cellData=(unsigned char *) (0x20190750);
            break;
          case(0x06) : //K810_R8BA024
            cellData=(unsigned char *) (0x201853B4);
            break;
          case(0x07) : //K800_R8BF003
            cellData=(unsigned char *) (0x20184B70);
            break;
          case(0x08) : //W850_R1KG001
            cellData=(unsigned char *) (0x20175E54);
            break;
          case(0x09) : //W880_R8BA024
            cellData=(unsigned char *) (0x20175760);
            break;
          case(0x0A) : //W580_R8BA024
            cellData=(unsigned char *) (0x2018EC5C);
            break;
          case(0x0B) : //W660_R8BB001
            cellData=(unsigned char *) (0x20175D14);
            break;
        }
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[CUSTOM_CID]", 0)) {
        cellData=(unsigned char*)( (int) h2i(param));
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[LOG_FOLDER]", 0)) {
        logFolder = new u16[strlen(param) + 1];
        str2wstr(logFolder, param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[LOCATION]", 0)) {
        wnd = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[SHOW]", 0)) {
        show = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[KEY_MODE]", 0)) {
        keyMode = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[LOG_EXT]", 0)) {
        logExt = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[DATE_FORMAT]", 0)) {
        dateFormat = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[VIBRATE]", 0)) {
        vibrateMode = h2i(param);
        if (vibrateMode == 2) vibrateTime = 250;
        if (vibrateMode == 3) vibrateTime = 500;
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[LOG_MODE]", 0)) {
        logMode = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[UPDATE_INTERVAL]", 0)) {
        updateInterval = h2i(param) * 1000;
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[ALWAYS_UPDATE]", 0)) {
        alwaysUpdate = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[IGNORE_KEYLOCK]", 0)) {
        ignoreKeyLock = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[SOUND_FOLDER]", 0)) {
        soundFolder = new u16[strlen(param) + 1];
        str2wstr(soundFolder, param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[SHOWCELLID]", 0)) {
        keyShowCellID = h2i(param);
        mfree(param);
      }
      if(param = manifest_GetParam(buffer, "[WIN2UNICODE_FILE]", 0))
      {
        str2wstr(winUCodeFile, param);
        mfree(param);
      }
      if(param = manifest_GetParam(buffer, "[NEW_ACTION_TIMEOUT]", 0))
      {
        minNewAction = h2i(param)*60000;
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[CELLID_MODE]", 0)) {
        CellIdMode = h2i(param);
        mfree(param);
      }
      if (param = manifest_GetParam(buffer, "[AUTOLOCATION]", 0)) {
        keyAutoLoc = h2i(param);
        mfree(param);
      }
      mfree(buffer);
    }
    fclose(file);
    return 1;
  }
  return 0;
}

BOOK * CreateMiniGPSBook() {
  MiniGPSBook = new BOOK;
  CreateBook(MiniGPSBook, onCloseMiniGPSBook, &base_page, ELFNAME, -1, 0);
  return(MiniGPSBook);
}

int main(void) 
{
  BOOK* alreadyrunned=FindBook(isMiniGPSBook);
  if(alreadyrunned)
  {
    MessageBox(0x6FFFFFFF, STR("MiniGPS\nalready running"), 0, 1 ,5000, 0);
  }
  else
  {
    if (GetSettings() == 0)
    {
      MessageBox(0x6FFFFFFF, STR("MiniGPS.ini\nNo ini file found!"), 0, 1 ,5000, 0);
      SUBPROC(elf_exit);
    }
    else
    {
      if (cellData == 0)
      {
        MessageBox(0x6FFFFFFF, STR("Configuration error!\nPhone not supported."), 0, 1 ,5000, 0);
        SUBPROC(elf_exit);
      } 
      else 
      {
        FSTAT fstat;
        if(isFileExist(GetDir(DIR_INI),winUCodeFile, &fstat)!=0)
        {
          MessageBox(0x6FFFFFFF, STR("win2unicode_file!\nNo bin file found!"), 0, 1 ,5000, 0);
          SUBPROC(elf_exit);
        }
        else
        {
          CreateMiniGPSBook();
          ModifyKeyHook(NewKey, 1);
          timer = Timer_Set(1000, onTimer, 0);
        }
      }
    }
  }
  return(0);
}
